/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.util;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;

public abstract class EnumConverter<E extends Enum<E>>
implements ValueConverter<E> {
    private final Class<E> clazz;
    private String delimiters = "[,]";

    protected EnumConverter(Class<E> clazz) {
        this.clazz = clazz;
    }

    @Override
    public E convert(String value) {
        try {
            return Enum.valueOf(this.valueType(), value);
        }
        catch (IllegalArgumentException e2) {
            throw new ValueConversionException(this.message(value), e2);
        }
    }

    @Override
    public Class<E> valueType() {
        return this.clazz;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    @Override
    public String valuePattern() {
        EnumSet<E> values = EnumSet.allOf(this.valueType());
        StringBuilder builder = new StringBuilder();
        builder.append(this.delimiters.charAt(0));
        Iterator i2 = values.iterator();
        while (i2.hasNext()) {
            builder.append(((Enum)i2.next()).toString());
            if (!i2.hasNext()) continue;
            builder.append(this.delimiters.charAt(1));
        }
        builder.append(this.delimiters.charAt(2));
        return builder.toString();
    }

    private String message(String value) {
        ResourceBundle bundle = ResourceBundle.getBundle("joptsimple.ExceptionMessages");
        Object[] arguments = new Object[]{value, this.valuePattern()};
        String template = bundle.getString(EnumConverter.class.getName() + ".message");
        return new MessageFormat(template).format(arguments);
    }
}

